--
-- main
-- 
-- Author: DaVaR
-- Description: Loads the mod and such
-- Name: main
-- Hide: yes
--

-- Designed for Farm Sim Game Bot and Website

---Init the mod.
local function init()

  -- Mod is loaded in to the game here.  Yay!
  print("Info: Loading FSG Server Companion")
  
  -- Overwrites the dedi xml link output
  GameStats.updateStatsPlayers = Utils.overwrittenFunction(GameStats.updateStatsPlayers, function(self)
    
    local xmlFile = self.statsXMLFile
    if xmlFile == nil then
      return
    elseif self.mission ~= nil then
      local userManager = self.mission.userManager
      local numUsed = userManager:getNumberOfUsers()
      if g_dedicatedServer ~= nil then
        numUsed = numUsed - 1
      end
      local capacity = self.mission.missionDynamicInfo.capacity or 0
      setXMLInt(xmlFile, "Server.Slots#capacity", capacity)
      setXMLInt(xmlFile, "Server.Slots#numUsed", numUsed)
      for i = 1, g_serverMaxCapacity do
        local playerKey = string.format("Server.Slots.Player(%d)", i - 1)
        removeXMLProperty(xmlFile, playerKey)
        if i <= capacity then
          local user = userManager:getUsers()[i + 1]
          if user == nil then
            setXMLBool(xmlFile, playerKey .. "#isUsed", false)
          else
            local connection = user:getConnection()
            local player
            if connection == nil then
              player = nil
            else
              player = self.mission.connectionsToPlayer[connection]
            end
            local playtime = (self.mission.time - user:getConnectedTime()) / 60000
            local uptime = math.round(playtime)
            setXMLBool(xmlFile, playerKey .. "#isUsed", true)
            setXMLBool(xmlFile, playerKey .. "#isAdmin", user:getIsMasterUser())
            setXMLInt(xmlFile, playerKey .. "#uptime", uptime)
            setXMLString(xmlFile, playerKey .. "#uniqueUserId", user:getUniqueUserId())
            if player ~= nil and (player.isControlled and (player.rootNode ~= nil and player.rootNode ~= 0)) then
              local x, y, z = getWorldTranslation(player.rootNode)
              setXMLFloat(xmlFile, playerKey .. "#x", x)
              setXMLFloat(xmlFile, playerKey .. "#y", y)
              setXMLFloat(xmlFile, playerKey .. "#z", z)
            end
            setXMLString(xmlFile, playerKey, HTMLUtil.encodeToHTML(user:getNickname(), true))
          end
        end
      end
    end

  end)
 
end


--- Makes things tick
init()