VehicleWorkshop = {}
local SPEC_NAME = ("spec_%s.vehicleWorkshop"):format(g_currentModName)
function VehicleWorkshop.prerequisitesPresent(specializations)
	return true
end
function VehicleWorkshop.registerOverwrittenFunctions(vehicleType)
	SpecializationUtil.registerOverwrittenFunction(vehicleType, "setOwnerFarmId", VehicleWorkshop.setOwnerFarmId)
end
function VehicleWorkshop.registerEventListeners(vehicleType)
	SpecializationUtil.registerEventListener(vehicleType, "onLoad", VehicleWorkshop)
	SpecializationUtil.registerEventListener(vehicleType, "onDelete", VehicleWorkshop)
end

function VehicleWorkshop.initSpecialization()
	Log:debug("VehicleWorkshop.initSpecialization")
	local schema = Vehicle.xmlSchema
	local baseKey = "vehicle.vehicleWorkshop"
	schema:setXMLSpecializationType("VehicleWorkshop")
	-- VehicleWorkshop.registerXMLPaths(schema, baseKey)
	VehicleSellingPoint.registerXMLPaths(schema, baseKey .. ".sellingPoint")
	schema:setXMLSpecializationType()
end

-- function VehicleWorkshop.registerXMLPaths(schema, baseKey)
-- 	Log:debug("VehicleWorkshop.registerXMLPaths")
-- 	schema:register(XMLValueType.INT, baseKey .. "#test", "Just a test")
-- end

function VehicleWorkshop:onLoad()
	local spec = self[SPEC_NAME]
	-- Log:table("self"	, self)
	-- local testValue = self.xmlFile:getValue("vehicle.vehicleWorkshop#test", 25)
	-- Log:var("SPEC_NAME", SPEC_NAME)
	spec.sellingPoint = VehicleSellingPoint.new()
	spec.sellingPoint:load(self.components, self.xmlFile, "vehicle.vehicleWorkshop.sellingPoint", self.i3dMappings)
	spec.sellingPoint:setOwnerFarmId(self:getOwnerFarmId())

	-- Log:table("spec", spec)

	-- Log:table("debug", {
	-- 	mobileWorkshop = self.mobileWorkshop,
	-- 	playerTrigger = self.playerTrigger
	-- })
end
function VehicleWorkshop.onDelete(self)
	local spec = self[SPEC_NAME]
	if spec.sellingPoint ~= nil then
		spec.sellingPoint:delete()
	end
end

function VehicleWorkshop.setOwnerFarmId(self, superFunc, farmId, noEventSend)
	local v13 = self[SPEC_NAME]
	superFunc(self, farmId, noEventSend)
	if v13.sellingPoint ~= nil then
		v13.sellingPoint:setOwnerFarmId(farmId)
	end
end
